
# Thompson Sampling for Multi-Objective Linear Contextual Bandit
This repository is the official implementation of Thompson Sampling for Multi-Objective Linear Contextual Bandit. It contains the implementation of algorithms $\texttt{MOL-TS}$, $\texttt{MOL-UCB}$, and $\texttt{MOL-}\epsilon\texttt{-greedy}$.



## Requirements

To install requirements:

```setup
pip install -r requirements.txt
```

## Running Algorithms

To run the algorithm, run this commend:

```train
python main.py
```

>📋  All the hyperparameters are easily denoted and can be changed in main.py.

## Experiment Structure

After running main.py, all the data and results will be in data folder and results folder, respectively.
```
├── agent
│    ├──  __init__.py
│    ├──  base_model.py
│    ├──  MOLB_Greedy.py
│    ├──  MOLB_TS.py
│    ├──  MOLB_UCB.py
│    └──  PFIwR.py
├── data                            
├── environment
│    ├──  __init__.py
│    ├──  base_env.py
│    ├──  mo_context_linear_env.py
│    └──  multiobjective.py
├── results
├── main.py
├── save_param.py
├── utils.py
├── README.md
└── requirements.txt
```